### 实验名称

MongoDB 安装

### **实验目的**

1. 完成 MongoDB 的下载、安装及卸载；
2. 能够正常启动、关闭 MongoDB，掌握 MongoDB 配置文件的含义。

### **实验背景**

MongoDB 是一个基于分布式文件存储的数据库。由 C++ 语言编写。旨在为 Web 应用提供可扩展的高性能数据存储解决方案。

MongoDB 是一个介于关系数据库和非关系数据库之间的产品，是非关系数据库当中功能最丰富，最像关系数据库的。

### **实验原理**

基于 Ubuntu 18.04 LTS（长期支持）版本下完成 MongoDB 6.0.8 社区版的下载、安装、启动及卸载。

### **实验环境**

OS：Ubuntu 18.04.3 LTS

MongoDB：6.0.8

### **建议课时**

1课时

### **实验步骤**

题目一：MongoDB 下载、安装

1. 导入包管理系统使用的公钥

   （1）先更新一下本地包数据库

   ```sh
   sudo apt-get update
   ```

   （2）安装 `gnupg` 和 `curl`

   ```sh
   sudo apt-get install gnupg curl
   ```

   ![03-1-1-安装gnupg和curl.png](./pic/03-1-1-安装gnupg和curl.png)

   （3）导入 MongoDB GPG 公钥

   ```sh
   curl -fsSL https://pgp.mongodb.com/server-6.0.asc | sudo gpg -o /usr/share/keyrings/mongodb-server-6.0.gpg --dearmor
   ```

   ![03-1-2-导入GPG公钥.png](./pic/03-1-2-导入GPG公钥.png)

2. 为 MongoDB 创建一个列表文件

   （1）查看 Linux 版本

   ```sh
   lsb_release -dc
   ```

   ![03-1-3-查看Linux版本.png](./pic/03-1-3-查看Linux版本.png)

   （2）创建列表文件：

   ```sh
   echo "deb [ arch=amd64,arm64 signed-by=/usr/share/keyrings/mongodb-server-6.0.gpg ] https://repo.mongodb.org/apt/ubuntu bionic/mongodb-org/6.0 multiverse" | sudo tee /etc/apt/sources.list.d/mongodb-org-6.0.list
   ```

   ![03-1-4-创建列表文件.png](./pic/03-1-4-创建列表文件.png)

3. 重新加载本地包数据库

   ```sh
   sudo apt-get update
   ```

   ![03-1-5-更新包数据库.png](./pic/03-1-5-更新包数据库.png)

   ![03-1-6-更新包数据库.png](./pic/03-1-6-更新包数据库.png)

4. 安装 MongoDB

   （1）安装

   ```sh
   sudo apt-get install -y mongodb-org
   ```

   ![03-1-7-安装MongoDB.png](./pic/03-1-7-安装MongoDB.png)

   ![03-1-8-安装MongoDB.png](./pic/03-1-8-安装MongoDB.png)

   （2）固定版本，防止意外升级

   ```sh
   echo "mongodb-org hold" | sudo dpkg --set-selections
   echo "mongodb-org-database hold" | sudo dpkg --set-selections
   echo "mongodb-org-server hold" | sudo dpkg --set-selections
   echo "mongodb-mongosh hold" | sudo dpkg --set-selections
   echo "mongodb-org-mongos hold" | sudo dpkg --set-selections
   echo "mongodb-org-tools hold" | sudo dpkg --set-selections
   ```

   ![03-1-9-固定版本.png](./pic/03-1-9-固定版本.png)

5. 查看 MongoDB

   （1）查看配置文件

   使用以下命令查看配置文件 `/etc/mongod.conf`，其中描述了 MongoDB **默认创建**的数据存储路径、日志存储路径以及 mongod 服务的端口号

   ```sh
   cat /etc/mongod.conf
   ```

   ![03-1-10-查看配置文件.png](./pic/03-1-10-查看配置文件.png)

   （2）查看版本信息

   ```sh
   mongod -version
   ```

   ![03-1-11-查看MongoDB版本.png](./pic/03-1-11-查看MongoDB版本.png)

题目二：启动 MongoDB

1. 启动 MongoDB

   （1）首先在 `/home/ubuntu` 目录下建立 mongodb 文件夹

   ```sh
   cd /home/ubuntu
   ```

   （2）创建 MongoDB 数据库所在文件夹 data

   ```sh
   mkdir -p mongodb/data
   ```

   （3）创建 MongoDB 日志所在文件夹 log 及 log 日志文件 mongodb.log

   ```sh
   mkdir -p mongodb/log
   touch mongodb/log/mongodb.log
   ```

   ![03-1-12-创建文件夹及文件.png](./pic/03-1-12-创建文件夹及文件.png)

   注意：如果没有创建日志文件，mongod 服务将启动失败。

   （4）启动 mongod 服务，**自定义**数据库和日志文件

   ```sh
   mongod --dbpath /home/ubuntu/mongodb/data --logpath /home/ubuntu/mongodb/log/mongodb.log --logappend --fork
   ```

   \--dbpath：对应上面设置的数据库文件所在目录 data

   \--logpath：对应上面设置的日志文件所在目录 log

   \--logappend：日志以追加的形式添加 log 文件中，如果不设置此项，则日志覆盖

    --fork：此符号表示将 mongod 服务进程后台进行

2. 确认MongoDB已经成功启动

   通过 pgrep 命令查看 mongod 服务是否启动成功，显示出 pid 则表示已经启动成功

   ```markup
   pgrep mongo -l
   ```

   ![03-1-13-启动并验证.png](./pic/03-1-13-启动并验证.png)

3. 开始使用MongoDB

   在与 mongod 服务相同的主机上启动一个 mongo shell。如果没有任何命令行选项，则表示默认连接到在本地主机端口27017上运行的 mongod 服务。

   ```sh
   mongosh
   ```

   ![03-1-14-启动mongosh.png](./pic/03-1-14-启动mongosh.png)

   稍后，要停止 MongoDB，请在运行 mongod 服务实例的终端中按 Ctrl + C

   ![03-1-15-退出mongosh.png](./pic/03-1-15-退出mongosh.png)

   如果要停止 mongod 服务使用 kill pid（pid 为 pgrep 查询到的 pid）

   如用 pgrep 命令查到 mongod 服务的进程 pid 为 5832，则使用 `kill 5160` 命令来停止 mongd 服务即可。

   ```sh
   kill 5832
   ```

   ![03-1-16-关闭服务.png](./pic/03-1-16-关闭服务.png)

题目三：卸载MongoDB

要从系统中彻底删除 MongoDB，必须删除 MongoDB 应用程序本身，配置文件以及包含数据和日志的任何目录。 

以下部分将指导完成必要的步骤。

警告 : 这个过程将完全删除 MongoDB，它的配置和所有的数据库。这个过程是不可逆的，因此在继续之前确保备份所有的配置和数据。

1.  删除软件包

     删除以前安装的任何 MongoDB 软件包

    ```sh
    sudo apt-get purge mongodb-org*
    ```

    ![03-1-17-删除安装包.png](./pic/03-1-17-删除安装包.png)

    ![03-1-18-删除安装包.png](./pic/03-1-18-删除安装包.png)

2. 删除数据目录

   （1）删除 MongoDB **自定义的**数据库和日志文件

   删除前先停止服务。用 pgrep mongo -l 命令查到 mongod 服务的进程 pid，使用 kill pid 命令来停止 mongd 服务。

   ```sh
   sudo rm -r /home/ubuntu/mongodb/data
   sudo rm -r /home/ubuntu/mongodb/log
   ```

   ![03-1-19-删除文件夹.png](./pic/03-1-19-删除文件夹.png)

   （2）删除 MongoDB **默认的**数据库和日志文件

   ```sh
   sudo rm -r /var/log/mongodb
   sudo rm -r /var/lib/mongodb
   ```

   ![03-1-20-删除文件夹.png](./pic/03-1-20-删除文件夹.png)

   可能遇到的问题：27017 端口被占用，可能是因为上次用过没有正常关闭端口监听。

### 实验总结

通过本次实验，能够掌握 Ubuntu18.04 版本下 MongoDB 6.0.8 的下载、安装、启动以及卸载，能够掌握 MongoDB 配置文件 mongod.conf 的含义。